    NAME OsScreen

; This is Os.Screen.Asm.

CGROUP GROUP CODE


EXTRN  font57: NEAR

PUBLIC CpAddrOfSystemFont
PUBLIC SetScreenMode
PUBLIC CpScreenInfo, CpScreenInfoNear

PUBLIC emsBase


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP


emsBase DW 0FFFFH          ; Init to -1 to flag that it isn't set yet


;   CpAddrOfSystemFont
;
;  This routine returns a pointer to the built-in system font
;

CpAddrOfSystemFont PROC FAR
  PUSH CS
  POP  ES
  MOV  BX, OFFSET font57
  RET
CpAddrOfSystemFont ENDP


;   SetScreenMode: PROCEDURE CLEAN;
;
;  This routine will set the screen to Graphics mode
;  It also initializes emsBase the first time it is called
;

SetScreenMode PROC FAR
  CMP  CS:emsBase, 0FFFFH
  JNE  SetScrModeEmsBaseSet

  INT  71H                    ; Call to Cp Module
  DB   58H                    ; EmsStartAddress
  MOV  CS:emsBase, AX

SetScrModeEmsBaseSet:
  MOV  AX, 6
  PUSH BP
  INT  10h                    ; 640x200 BW, clear screen
  POP  BP                     ; Int 10 may destroy BP
  RET
SetScreenMode ENDP  


;    CpScreenInfo : PROCEDURE (pInfo) CLEAN;
;      DCL pInfo     PTR;
;      DCL info      BASED pInfo  ScreenInfoType;
;
;    This will return information about screen size, etc.

ScreenInfoType STRUC
  xPixels    DW ?
  yPixels    DW ?
  pScreenOff DW ?
  pScreenSeg DW ?
  bitsPerPel DB ?
  yAspect    DW ?
ScreenInfoType ENDS

screenInfo   EQU ES:[DI]
pScreenInfo  EQU DWORD PTR [BP+6]

CpScreenInfo PROC FAR
CpScreenInfoNear LABEL NEAR
  PUSH BP
  MOV  BP, SP

  LES  DI, pScreenInfo
  MOV  screenInfo.xPixels, 640
  MOV  screenInfo.yPixels, 200
  MOV  screenInfo.yAspect, 140
  MOV  screenInfo.pScreenSeg, 0B800h

  MOV  screenInfo.pScreenOff, 0
  MOV  screenInfo.bitsPerPel, 1

  POP  BP
  RET  4
CpScreenInfo ENDP

PURGE screenInfo
PURGE pScreenInfo
PURGE ScreenInfoType
PURGE xPixels
PURGE yPixels
PURGE pScreenOff
PURGE pScreenSeg
PURGE bitsPerPel
PURGE yAspect

CODE ENDS

    END
